using System;
using System.Collections.Generic;
using System.Linq;

namespace Grouping
{
    class Program
    {
        static void Main(string[] args)
        {
            List<CalendarEvent> events = new List<CalendarEvent>
            {
                new CalendarEvent
                {
                    Title = "Swingowa potańcówka na nabrzeżu",
                    StartTime = new DateTimeOffset (2009, 7, 11, 15, 00, 00, TimeSpan.Zero),
                    Duration = TimeSpan.FromHours(4)
                },
                new CalendarEvent
                {
                    Title = "Sobotnia noc swingowa",
                    StartTime = new DateTimeOffset (2009, 7, 11, 19, 30, 00, TimeSpan.Zero),
                    Duration = TimeSpan.FromHours(6.5)
                },
                new CalendarEvent
                {
                    Title = "Formula 1 - Grand Prix Niemiec",
                    StartTime = new DateTimeOffset (2009, 7, 12, 12, 10, 00, TimeSpan.Zero),
                    Duration = TimeSpan.FromHours(3)
                },
                new CalendarEvent
                {
                    Title = "Piknik swingowy",
                    StartTime = new DateTimeOffset (2009, 7, 12, 15, 00, 00, TimeSpan.Zero),
                    Duration = TimeSpan.FromHours(4)
                },
                new CalendarEvent
                {
                    Title = "Łamańce swingowe w klubie Setka",
                    StartTime = new DateTimeOffset (2009, 7, 13, 19, 45, 00, TimeSpan.Zero),
                    Duration = TimeSpan.FromHours(5)
                }
            };


            // Listing 8-15. Proste grupowanie w LINQ.
            var eventsByDay = from ev in events
                              group ev by ev.StartTime.Date;

            // Listing 8-16. Przeglądanie pogrupowanych wyników.
            foreach (var day in eventsByDay)
            {
                Console.WriteLine("Wydarzenia dla klucza: " + day.Key);
                foreach (var item in day)
                {
                    Console.WriteLine(item.Title);
                }
            }

            UsingInto(events);
        }

        static void UsingInto(List<CalendarEvent> events)
        {
            // Listing 8-17. Kontynuacja zapytania grupującego przy wykorzystaniu klauzuli into.
            var eventsByDay = from ev in events
                              group ev by ev.StartTime.Date into dayGroup
                              select dayGroup.ToArray();

            foreach (var day in eventsByDay)
            {
                Console.WriteLine();
                foreach (var item in day)
                {
                    Console.WriteLine(item.Title);
                }
            }
        }
    }
}
